﻿using System;
using System.Collections.Generic;
using System.Linq;


namespace WriteDbContextChangesToConsole
{
    public static class DbContextExtensions
    {
        /*
        /// <summary>
        /// Write changes to dbContext to the console window. for Entity Framework 6
        /// USAGE: 
        ///     using CPSentry.Repository;
        ///     lhCommonDbContext.WriteDbContextChangesToConsole();
        /// </summary>
        /// <param name="dbContext"></param>
        public static void WriteDbContextChangesToConsole(this System.Data.Entity.DbContext dbContext)
        {
            var changedEntries = dbContext.ChangeTracker.Entries().Where(x => x.State != System.Data.Entity.EntityState.Unchanged).ToList();

            if (0 == changedEntries.Count)
            {
                System.Console.WriteLine("No changed entries.");
            }
            else
            {
                const int propertyNameLength = 30;
                const int actionLength = 20;
                const int originalValueLength = 30;
                const int currentValueLength = 30;
                const int totalLength = propertyNameLength + actionLength + originalValueLength + currentValueLength + 9; // 9 characters for space pipe space between columns.

                foreach (var entry in changedEntries)
                {
                    // Print name of entity and column headers.
                    var entityRealName = (entry.Entity.GetType().IsValueType || (null == entry.Entity.GetType().BaseType) ? entry.Entity.GetType().Name : entry.Entity.GetType().BaseType?.Name);

                    System.Console.WriteLine(new String('_', totalLength));
                    System.Console.WriteLine($"{entityRealName}:");
                    System.Console.WriteLine(new String('_', totalLength));
                    System.Console.WriteLine($"{"Property Name",propertyNameLength} | {"Action",actionLength} | {"Original Value",originalValueLength} | {"Current Value",currentValueLength}");

                    System.Console.WriteLine(new String('_', totalLength));

                    switch (entry.State)
                    {
                        case System.Data.Entity.EntityState.Added:
                            {
                                foreach (var propertyName in entry.CurrentValues.PropertyNames)
                                {
                                    var currentValue = (entry.CurrentValues[propertyName] ?? "null").ToString().SubString(0, currentValueLength, true);

                                    System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Added",actionLength} | {"-",originalValueLength} | {currentValue,currentValueLength}");
                                }

                                break;
                            }
                        case System.Data.Entity.EntityState.Modified:
                            {
                                foreach (var propertyName in entry.CurrentValues.PropertyNames)
                                {
                                    var originalValue = (entry.OriginalValues[propertyName] ?? "null").ToString().SubString(0, originalValueLength, true);
                                    var currentValue = (entry.CurrentValues[propertyName] ?? "null").ToString().SubString(0, currentValueLength, true);

                                    if (originalValue != currentValue)
                                        System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Modified",actionLength} | {originalValue,originalValueLength} | {currentValue,currentValueLength}");
                                }
                                break;
                            }
                        case System.Data.Entity.EntityState.Deleted:
                            {
                                foreach (var propertyName in entry.OriginalValues.PropertyNames)
                                {
                                    var originalValue = (entry.OriginalValues[propertyName] ?? "null").ToString().SubString(0, originalValueLength, true);

                                    System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Deleted",actionLength} | {originalValue,originalValueLength} | {"-",currentValueLength}");
                                }
                                break;
                            }
                        default: { break; }
                    }
                }
            }
        }
        */


        /// <summary>
        /// Write changes to dbContext to the console window for Entiry Framework Core.
        /// USAGE: 
        ///     using CPSentry.Repository;
        ///     lhCommonDbContext.WriteDbContextChangesToConsole();
        /// </summary>
        /// <param name="dbContext"></param>
        public static void WriteDbContextChangesToConsole(this Microsoft.EntityFrameworkCore.DbContext dbContext)
        {
            var changedEntries = dbContext.ChangeTracker.Entries().Where(x => x.State != Microsoft.EntityFrameworkCore.EntityState.Unchanged).ToList();

            if (0 == changedEntries.Count)
            {
                System.Console.WriteLine("No changed entries.");
            }
            else
            {
                const int propertyNameLength = 30;
                const int actionLength = 20;
                const int originalValueLength = 30;
                const int currentValueLength = 30;
                const int totalLength = propertyNameLength + actionLength + originalValueLength + currentValueLength + 9; // 9 characters for space pipe space between columns.

                foreach (var entry in changedEntries)
                {
                    // Print name of entity and column headers.
                    var entityRealName = entry.Entity.GetType().Name;

                    System.Console.WriteLine(new String('_', totalLength));
                    System.Console.WriteLine($"{entityRealName}:");
                    System.Console.WriteLine(new String('_', totalLength));
                    System.Console.WriteLine($"{"Property Name",propertyNameLength} | {"Action",actionLength} | {"Original Value",originalValueLength} | {"Current Value",currentValueLength}");

                    System.Console.WriteLine(new String('_', totalLength));

                    switch (entry.State)
                    {
                        case Microsoft.EntityFrameworkCore.EntityState.Added:
                            {
                                foreach (var property in entry.CurrentValues.Properties)
                                {
                                    var propertyName = property.Name;
                                    var currentValue = (entry.CurrentValues[propertyName] ?? "null").ToString().SubString(0, 20, true);

                                    System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Added",actionLength} | {"-",originalValueLength} | {currentValue,currentValueLength}");
                                }

                                break;
                            }
                        case Microsoft.EntityFrameworkCore.EntityState.Modified:
                            {
                                foreach (var property in entry.CurrentValues.Properties)
                                {
                                    var propertyName = property.Name;
                                    var originalValue = (entry.OriginalValues[propertyName] ?? "null").ToString().SubString(0, 20, true);
                                    var currentValue = (entry.CurrentValues[propertyName] ?? "null").ToString().SubString(0, 20, true);

                                    if (originalValue != currentValue)
                                        System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Modified",actionLength} | {originalValue,originalValueLength} | {currentValue,currentValueLength}");
                                }
                                break;
                            }
                        case Microsoft.EntityFrameworkCore.EntityState.Deleted:
                            {
                                foreach (var property in entry.OriginalValues.Properties)
                                {
                                    var propertyName = property.Name;
                                    var originalValue = (entry.OriginalValues[propertyName] ?? "null").ToString().SubString(0, 20, true);

                                    System.Console.WriteLine($"{propertyName,propertyNameLength} | {"Deleted",actionLength} | {originalValue,originalValueLength} | {"-",currentValueLength}");
                                }
                                break;
                            }
                        default: { break; }
                    }
                }
            }
        }


        /// <summary>
        /// Returns the specified number of characters beginning at the startIndex.
        /// A null string will return an empty string.
        /// If start index is outside the string, startIndex = 0;
        /// If length is longer than the string or negative, all characters after the startIndex will be returned.
        /// If withEllipse is true then the string will be truncated 3 characters and "..." will be appended.
        /// Post .Net 6 update:  Change to interface to public static string SubString(this string? theString, int startIndex, int length, bool withEllipse = false)

        /// </summary>
        /// <param name="theString"></param>
        /// <param name="startIndex"></param>
        /// <param name="length"></param>
        /// <param name="withEllipse"></param>
        /// <returns></returns>
        public static string SubString(this string theString, int startIndex, int length, bool withEllipse = false)
        {
            // Handle null string.
            theString = theString ?? string.Empty;

            if (0 < theString.Length)
            {
                // Handle invalid start index.
                if (0 > startIndex || startIndex > theString.Length)
                    startIndex = 0;

                // Handle invalid length.
                if (0 > length || length > theString.Length - startIndex)
                    length = theString.Length - startIndex;

                if (withEllipse && (theString.Length - startIndex) > length)
                    theString = theString.Substring(startIndex, length - 3) + "...";
                else
                    theString = theString.Substring(startIndex, length);
            }

            return theString ?? string.Empty;
        }
    }
}
