﻿using Microsoft.Data.Sqlite;

using WriteDbContextChangesToConsole;


namespace SQLiteDemo
{
    public static class Globals
    {
        public const string DatabaseConnectionString = @"DataSource=./SQLiteDemo.db";
    }


    internal class WriteDbContextChangesToConsole
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Hello, World!");

            using (var _dbContext = new CountryCapitalsDbContext())
            {
                // Delete the SQLite database file if it exists.
                _dbContext.Database.EnsureDeleted();
                // Create the SQLite database file if it does not exist.
                _dbContext.Database.EnsureCreated();
                
                // Populate the database table with data.
                _dbContext.Populate();
                Console.WriteLine($"Number of Countries: {_dbContext.CountryCapitals.Count()}");

                Console.WriteLine("Add a new country Milo with capital Sammi City.");
                _dbContext.CountryCapitals.Add(new CountryCapital { CountryName = "Milo", CapitalName = "Sammi City" });
                
                Console.WriteLine("Rename a capital to Codyville.");
                _dbContext.CountryCapitals.Single(x => x.Id == 66).CapitalName = "Codyville";

                Console.WriteLine("Remove a country.");
                _dbContext.CountryCapitals.Remove(_dbContext.CountryCapitals.Single(x => x.Id == 100));

                // Write changes to DbContext to console window.
                _dbContext.WriteDbContextChangesToConsole();

                _dbContext.SaveChanges();

                Console.WriteLine($"New Number of Countries: {_dbContext.CountryCapitals.Count()}");
            }

            Console.WriteLine("Goodbye!");
        }
    }
}
